/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.model.AverageValueParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.TimeBase;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.model.panel.StopWatchPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AverageValuePanel
extends AbstractProtectionPanel {
    private static final long serialVersionUID = 4092199171827868312L;
    private JPanel fMainPanel;
    private AverageValueParameterPanel fContentPanel;

    public AverageValuePanel() {
    }

    public AverageValuePanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.fMainPanel = new JPanel(new GridBagLayout());
        this.addParameterPane(this.fMainPanel);
        this.fContentPanel = new AverageValueParameterPanel(parameterReference);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 5, 5, 0);
        gbc.anchor = 17;
        this.fMainPanel.add((Component)this.fContentPanel, gbc);
        JPanel notePanel = new JPanel();
        String note = "<html>When Enable = 0, the calculation will be stopped and the output will be stable.<br>When Reset = 1, all actual values will be reset to 0.</html>";
        notePanel.add(new JLabel(Language.getString("dialog.parameter.averageValue.note", note)));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.anchor = 17;
        this.fMainPanel.add((Component)notePanel, gbc);
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        this.fContentPanel.loadFieldContents();
    }

    public boolean checkChanged() {
        if (this.fContentPanel.checkChanged()) {
            return true;
        }
        return super.checkChanged();
    }

    public boolean checkFieldContents() {
        return this.fContentPanel.checkFieldContents();
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        AverageValueParameter parameter = (AverageValueParameter)this.fParameterReference;
        if (this.fSimulationMode) {
            parameter.resetParameter();
        }
        this.fContentPanel.storeFieldContents();
    }

    public static class AverageValueParameterPanel
    extends JPanel {
        protected Parameter fParameterReference;
        private EditableNumericSpinner fSampleTimeSpinner;
        private JComboBox fTimeBaseCombo;
        private EditableNumericSpinner fSampleNumSpinner;
        private JPanel fSampleTimePanel;
        private JPanel fSampleNumPanel;
        private JLabel fSampleTimeLbl;
        private JLabel fSampleNumLbl;

        public AverageValueParameterPanel(Parameter parameterReference) {
            this.fParameterReference = parameterReference;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 5, 5, 0);
            gbc.anchor = 17;
            this.add((Component)this.getSampleTimePanel(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(5, 5, 5, 0);
            gbc.anchor = 17;
            this.add((Component)this.getSampleNumPanel(), gbc);
        }

        public JPanel getSampleTimePanel() {
            if (this.fSampleTimePanel == null) {
                this.fSampleTimePanel = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.insets = new Insets(5, 5, 5, 0);
                gbc.anchor = 17;
                this.fSampleTimeLbl = new JLabel(Language.getString("dialog.parameter.averageValue.sampleTime", "Sampling time"));
                this.fSampleTimePanel.add((Component)this.fSampleTimeLbl, gbc);
                this.fSampleTimeSpinner = new EditableNumericSpinner();
                this.fSampleTimeSpinner.setColumns(5);
                this.fSampleTimeSpinner.setMin(1);
                this.fSampleTimeSpinner.addNumericSpinnerListener(new TimeInputListener());
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.insets = new Insets(5, 5, 5, 5);
                this.fSampleTimePanel.add((Component)this.fSampleTimeSpinner, gbc);
                this.fTimeBaseCombo = new JComboBox();
                DefaultComboBoxModel<TimeBase> comboBoxModel = new DefaultComboBoxModel<TimeBase>(AverageValueParameter.getAvailableTimeBases());
                this.fTimeBaseCombo.setModel(comboBoxModel);
                this.fTimeBaseCombo.setRenderer(new StopWatchPanel.TimeBaseListCellRender());
                this.fTimeBaseCombo.addItemListener(new TimeBaseItemListener());
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 0;
                gbc.insets = new Insets(5, 0, 5, 0);
                this.fSampleTimePanel.add((Component)this.fTimeBaseCombo, gbc);
            }
            return this.fSampleTimePanel;
        }

        public JLabel getSampleTimeLabel() {
            return this.fSampleTimeLbl;
        }

        public JPanel getSampleNumPanel() {
            if (this.fSampleNumPanel == null) {
                this.fSampleNumPanel = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.insets = new Insets(5, 5, 5, 0);
                gbc.anchor = 17;
                this.fSampleNumLbl = new JLabel(Language.getString("dialog.parameter.averageValue.sampleNumber", "Numer of samples"));
                this.fSampleNumPanel.add((Component)this.fSampleNumLbl, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.insets = new Insets(5, 5, 5, 5);
                this.fSampleNumSpinner = new EditableNumericSpinner();
                this.fSampleNumSpinner.setColumns(5);
                this.fSampleNumSpinner.setMin(1);
                this.fSampleNumPanel.add((Component)this.fSampleNumSpinner, gbc);
            }
            return this.fSampleNumPanel;
        }

        public JLabel getSampleNumLabel() {
            return this.fSampleNumLbl;
        }

        public void loadFieldContents() {
            AverageValueParameter parameter = (AverageValueParameter)this.fParameterReference;
            this.setMaxSample(parameter.getSamplingTime().getTimeBaseKey(), parameter.getSamplingTime().getTime());
            this.fSampleTimeSpinner.setValue(parameter.getSamplingTime().getTime());
            ComboBoxModel comboBoxModel = this.fTimeBaseCombo.getModel();
            int modelSize = comboBoxModel.getSize();
            for (int i = 0; i < modelSize; ++i) {
                if (((TimeBase)comboBoxModel.getElementAt(i)).getTimeBaseKey() != parameter.getSamplingTime().getTimeBaseKey()) continue;
                this.fTimeBaseCombo.setSelectedIndex(i);
                break;
            }
            this.fSampleNumSpinner.setValue(parameter.getSampleNumber().getCurrentValue());
        }

        public boolean checkChanged() {
            AverageValueParameter parameter = (AverageValueParameter)this.fParameterReference;
            return this.fSampleTimeSpinner.getValue() != parameter.getSamplingTime().getTime() || !this.fTimeBaseCombo.getSelectedItem().equals(parameter.getSamplingTime()) || this.fSampleNumSpinner.getValue() != parameter.getSampleNumber().getCurrentValue();
        }

        public boolean checkFieldContents() {
            return this.fSampleTimeSpinner.checkValue(true) && this.fSampleNumSpinner.checkValue(true);
        }

        public void storeFieldContents() {
            AverageValueParameter parameter = (AverageValueParameter)this.fParameterReference;
            parameter.getSamplingTime().setTime(this.fSampleTimeSpinner.getValue());
            parameter.getSamplingTime().setTimeBaseKey(((TimeBase)this.fTimeBaseCombo.getSelectedItem()).getTimeBaseKey());
            parameter.getSampleNumber().setCurrentValue(this.fSampleNumSpinner.getValue());
        }

        public void setMaxSample(int timeBasekey, int sampleTime) {
            int maxTime = 0;
            switch (timeBasekey) {
                case 4: {
                    maxTime = AverageValueParameter.MAX_TIME_VALUE_DAY;
                    break;
                }
                case 3: {
                    maxTime = AverageValueParameter.MAX_TIME_VALUE_HOUR;
                    break;
                }
                case 2: {
                    maxTime = AverageValueParameter.MAX_TIME_VALUE_MINITUE;
                    break;
                }
                case 1: {
                    maxTime = AverageValueParameter.MAX_TIME_VALUE_SECOND;
                    break;
                }
            }
            this.fSampleTimeSpinner.setMax(maxTime);
            this.fSampleNumSpinner.setMax(((AverageValueParameter)this.fParameterReference).calculateMaxSampleNum(timeBasekey, sampleTime));
            this.fSampleTimeSpinner.setColumns(5);
            this.fSampleNumSpinner.setColumns(5);
        }

        class TimeInputListener
        implements NumericSpinnerListener {
            TimeInputListener() {
            }

            public void spinnerChanged(SpinnerChangedEvent se) {
                TimeBase timebase = (TimeBase)AverageValueParameterPanel.this.fTimeBaseCombo.getSelectedItem();
                if (AverageValueParameterPanel.this.fSampleTimeSpinner.getValue() == 0) {
                    return;
                }
                AverageValueParameterPanel.this.fSampleNumSpinner.setMax(((AverageValueParameter)AverageValueParameterPanel.this.fParameterReference).calculateMaxSampleNum(timebase.getTimeBaseKey(), AverageValueParameterPanel.this.fSampleTimeSpinner.getValue()));
                AverageValueParameterPanel.this.fSampleNumSpinner.setColumns(5);
            }
        }

        class TimeBaseItemListener
        implements ItemListener {
            TimeBaseItemListener() {
            }

            public void itemStateChanged(ItemEvent e) {
                Object obj = e.getSource();
                if (obj == AverageValueParameterPanel.this.fTimeBaseCombo) {
                    AverageValueParameterPanel.this.setMaxSample(((TimeBase)AverageValueParameterPanel.this.fTimeBaseCombo.getSelectedItem()).getTimeBaseKey(), AverageValueParameterPanel.this.fSampleTimeSpinner.getValue());
                }
            }
        }
    }
}

